<?php
// Porto info_list_item

add_shortcode('porto_info_list_item', 'porto_shortcode_info_list_item');
add_action('vc_after_init', 'porto_load_info_list_item_shortcode');

function porto_shortcode_info_list_item( $atts, $content = null ) {

    ob_start();
    if  ($template = porto_shortcode_template( 'porto_info_list_item' ) ) {
        include $template;
    }
    return ob_get_clean();
}

function porto_load_info_list_item_shortcode() {

    $custom_class = porto_vc_custom_class();

    vc_map(
        array(
           "name" => __("Porto Info List Item","porto-shortcodes"),
           "base" => "porto_info_list_item",
           "class" => "porto_info_list_item",
           "icon" => "porto4_vc_info_list_item",
           "category" => __( 'Porto', 'porto-shortcodes' ),
           "as_child" => array('only' => 'porto_info_list'),
           "content_element" => true,
           "show_settings_on_create" => true,
           "is_container"    => false,
           "params" => array(
                array(
                    "type" => "dropdown",
                    "heading" => __("Icon Type", "porto-shortcodes"),
                    "param_name" => "icon_type",
                    "value" => array(
                      __( 'Font Awesome', 'porto-shortcodes' ) => 'fontawesome',
                      __( 'Simple Line Icon', 'porto-shortcodes' ) => 'simpleline',
                      __( 'Porto Icon', 'porto-shortcodes' ) => 'porto',
                      __( 'Icon Image', 'porto-shortcodes' ) => 'image',
                    )
                ),
                array(
                    "type" => "iconpicker",
                    "class" => "",
                    "heading" => __("Icon", "porto-shortcodes"),
                    "param_name" => "list_icon",
                    "description" => __("Select the icon.", "porto-shortcodes"),
                    "dependency" => array(
                      "element" => "icon_type",
                      "value" => array( 'fontawesome' )
                    )
                ),
                array(
                    "type" => "iconpicker",
                    "class" => "",
                    "heading" => __("Icon", "porto-shortcodes"),
                    "param_name" => "list_icon_simpleline",
                    "description" => __("Select the icon.", "porto-shortcodes"),
                    'settings' => array(
                        'type' => 'simpleline',
                        'iconsPerPage' => 4000,
                    ),
                    "dependency" => array(
                      "element" => "icon_type",
                      "value" => array( 'simpleline' )
                    )
                ),
                array(
                    "type" => "iconpicker",
                    "class" => "",
                    "heading" => __("Icon", "porto-shortcodes"),
                    "param_name" => "list_icon_porto",
                    "description" => __("Select the icon.", "porto-shortcodes"),
                    'settings' => array(
                        'type' => 'porto',
                        'iconsPerPage' => 4000,
                    ),
                    "dependency" => array(
                      "element" => "icon_type",
                      "value" => array( 'porto' )
                    )
                ),
                array(
                    "type" => "attach_image",
                    "class" => "",
                    "heading" => __("Icon Image", "porto-shortcodes"),
                    "param_name" => "list_icon_img",
                    "description" => __("Select the icon image.", "porto-shortcodes"),
                    "dependency" => array(
                      "element" => "icon_type",
                      "value" => array( 'image' )
                    )
                ),
                array(
                    "type" => "number",
                    "class" => "",
                    "heading" => __("Desc Font Size", "porto-shortcodes"),
                    "param_name" => "desc_font_size"
                ),
                array(
                    "type" => "textarea_html",
                    "class" => "",
                    "heading" => __("Description", "porto-shortcodes"),
                    "param_name" => "content",
                    "value" => "",
                    "description" => __("Provide the description for this icon box.", "porto-shortcodes"),
                    "edit_field_class" => "vc_col-xs-12 vc_column wpb_el_type_textarea_html vc_wrapper-param-type-textarea_html vc_shortcode-param",
                ),
                $custom_class
            )
        )
    );

    class WPBakeryShortCode_porto_info_list_item extends WPBakeryShortCode {
    }

}